// --------------------------------------------------------------------------
//  FLIP32.H             copyright (c) 1996-97, Xavier Defrang (aka brioche)
// --------------------------------------------------------------------------
//  very simple header for a flat 32-bit protected mode animation player
// --------------------------------------------------------------------------
//  e-mail: 106146.1452@compuserve.com
// --------------------------------------------------------------------------

#include <STDIO.H>
#include <STDLIB.H>
#include <CONIO.H>

#ifndef __FLIP32

#define __FLIP32

#ifndef __TYPES
#include "TYPES.H"
#endif

typedef struct { UDWORD size;
		 UWORD magic, frames, scrwd, scrht, depth, flags, speed;
		 UDWORD next, frit;
		 UBYTE filler[0x66];
	       } FLIHEADER;
typedef struct { UDWORD size;
		 UWORD magic, chunks;
		 UBYTE filler[0x08];
	       } FRAMEHEADER;

FLIHEADER flihdr;
FRAMEHEADER framehdr;
FILE *flifile;
UDWORD flisize, framecnt;
UBYTE *framebuf;

// --------------------------------------------------------------------------

BOOL flip32_init( void );                                 // funcs prototypes
void flip32_done( void );
BOOL flip32_load( const char *filename );
void flip32_close( void );

// --------------------------------------------------------------------------

extern "C" {                                               // assembler routs
void vmode( UDWORD md );
#pragma aux vmode parm[eax] modify[eax];
void flip32_wait( UDWORD pause );
#pragma aux flip32_wait parm[ecx] modify[eax ecx edx];
void flip32_unpack( UBYTE *src, UBYTE *dst, UDWORD chunks );
};

// --------------------------------------------------------------------------

BOOL flip32_init( void )                // just allocate mem for frame buffer
{
 return( ( framebuf = (UBYTE *)malloc( 0xfffe ) ) != NULL );
}

// --------------------------------------------------------------------------

void flip32_done( void )                                // flush frame buffer
{
 free( framebuf );
}

// --------------------------------------------------------------------------

BOOL flip32_load( const char *filename )     // open file and read FLI header
{
 if ( !( flifile = fopen( filename, "rb" ) ) ) return( 0 ); 
 fseek( flifile, 0, SEEK_END );
 flisize = ftell( flifile );
 fseek( flifile, 0, SEEK_SET );
 fread( &flihdr, 128, 1, flifile );
 return( 1 );
}

// --------------------------------------------------------------------------

void flip32_close( void )                                       // close file
{
 fclose( flifile );
}

// --------------------------------------------------------------------------

#endif

// I told you there was only very basic stuff here! :)
